# MetricPoints Error Tracker WordPress Plugin

A comprehensive WordPress plugin for tracking JavaScript errors, performance metrics, and user sessions with MetricPoints.

## Features

- **JavaScript Error Tracking** - Captures unhandled errors and promise rejections
- **Performance Monitoring** - Tracks Core Web Vitals and memory usage
- **User Session Tracking** - Monitors user behavior and sessions
- **Admin Configuration** - Easy setup and configuration panel
- **Real-time Reporting** - Sends data to MetricPoints API
- **WordPress Integration** - Native WordPress admin interface

## Installation

1. **Upload the plugin** to your WordPress plugins directory
2. **Activate the plugin** in WordPress admin
3. **Go to Settings → MetricPoints Error Tracker**
4. **Enter your API Key and Project ID**
5. **Configure tracking options**
6. **Save changes**

## Configuration

### Required Settings
- **API Key** - Your MetricPoints API key
- **Project ID** - Your MetricPoints project ID

### Optional Settings
- **Enable Error Tracking** - Turn error tracking on/off
- **Performance Tracking** - Track Core Web Vitals and memory usage
- **User Tracking** - Track user sessions and behavior

## Usage

### Automatic Error Tracking
Once configured, the plugin automatically tracks:
- Unhandled JavaScript errors
- Promise rejections
- Performance metrics
- User session data

### Manual Testing
Use the admin panel to:
- Generate test errors
- Verify configuration
- Check tracking status

## API Integration

The plugin sends data to MetricPoints via:
- **Endpoint**: `https://metricpoints.com/api/error-reports`
- **Method**: POST
- **Authentication**: Bearer token (API key)
- **Format**: JSON

## Data Collected

### Error Data
- Error type and message
- Stack trace
- URL and line number
- User agent
- Timestamp

### Performance Data
- First Contentful Paint (FCP)
- Largest Contentful Paint (LCP)
- DOM Content Loaded
- Memory usage
- Connection information

### User Data
- Screen resolution
- Viewport size
- Language and timezone
- Referrer information

## Troubleshooting

### Common Issues

**Plugin not tracking errors:**
- Check API key is correct
- Verify project ID is valid
- Ensure error tracking is enabled
- Check browser console for errors

**Performance data not collected:**
- Enable performance tracking in settings
- Check browser compatibility
- Verify Core Web Vitals support

**API calls failing:**
- Check network connectivity
- Verify API key permissions
- Check WordPress error logs

### Debug Mode
Enable WordPress debug mode to see detailed error logs:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

## Support

For support and documentation:
- **Website**: https://metricpoints.com
- **Documentation**: https://metricpoints.com/docs
- **Support Email**: hello@metricpoints.com
- **Developer**: Michael Loeffler (Main Street Web Developer)
- **Developer Website**: https://mainstreetwebdeveloper.com

## Credits

Developed by Michael Loeffler at Main Street Web Developer for MetricPoints.com

## Changelog

### Version 1.0.0
- Initial release
- JavaScript error tracking
- Performance monitoring
- User session tracking
- Admin configuration panel
