# MetricPoints CSP Manager WordPress Plugin

A self-healing Content Security Policy management plugin for WordPress with MetricPoints integration.

## Features

- **CSP Management** - Configure and manage Content Security Policy
- **Self-Healing** - Automatically update CSP based on violations
- **Violation Reporting** - Track and report CSP violations
- **Admin Dashboard** - Monitor violations and policy changes
- **Real-time Updates** - Live policy updates based on violations
- **WordPress Integration** - Native WordPress admin interface

## Installation

1. **Upload the plugin** to your WordPress plugins directory
2. **Activate the plugin** in WordPress admin
3. **Go to Settings → MetricPoints CSP Manager**
4. **Enter your API Key and Project ID**
5. **Configure your CSP policy**
6. **Enable self-healing (optional)**
7. **Save changes**

## Configuration

### Required Settings
- **API Key** - Your MetricPoints API key
- **Project ID** - Your MetricPoints project ID
- **CSP Policy** - Your Content Security Policy

### Optional Settings
- **Enable CSP Management** - Turn CSP management on/off
- **Self-Healing** - Automatically update policy based on violations
- **Report URI** - URL for violation reporting

## Default CSP Policy

```html
default-src 'self'; 
script-src 'self' 'unsafe-inline' 'unsafe-eval'; 
style-src 'self' 'unsafe-inline'; 
img-src 'self' data: https:; 
font-src 'self' data:; 
connect-src 'self'; 
report-uri {REPORT_URI};
```

## Self-Healing Features

The plugin can automatically update your CSP policy when violations occur:

### How It Works
1. **Violation Detection** - Plugin detects CSP violations
2. **Analysis** - Analyzes the blocked resource
3. **Policy Update** - Adds necessary domains to directives
4. **Verification** - Tests updated policy

### Supported Updates
- **Script Sources** - Adds new domains to `script-src`
- **Style Sources** - Adds new domains to `style-src`
- **Image Sources** - Adds new domains to `img-src`
- **Font Sources** - Adds new domains to `font-src`
- **Connect Sources** - Adds new domains to `connect-src`

## Usage

### Automatic CSP Management
Once configured, the plugin:
- Applies CSP headers to all pages
- Monitors for violations
- Updates policy automatically (if enabled)
- Reports violations to MetricPoints

### Manual Testing
Use the admin panel to:
- Generate test CSP violations
- View recent violations
- Analyze and update policy
- Monitor self-healing status

## API Integration

The plugin sends violation data to MetricPoints via:
- **Endpoint**: `https://metricpoints.com/api/csp-reports`
- **Method**: POST
- **Authentication**: Bearer token (API key)
- **Format**: JSON

## Data Collected

### Violation Data
- Violated directive
- Blocked URI
- Document URI
- Source file and line number
- User agent
- Timestamp

### Policy Data
- Current CSP policy
- Policy updates
- Self-healing actions
- Violation patterns

## Troubleshooting

### Common Issues

**CSP not working:**
- Check policy syntax
- Verify headers are being sent
- Test with browser developer tools
- Check for conflicting plugins

**Violations not detected:**
- Ensure report-uri is correct
- Check browser console for errors
- Verify violation reporting is enabled
- Test with manual violations

**Self-healing not working:**
- Enable self-healing in settings
- Check for sufficient permissions
- Verify policy update logic
- Monitor admin logs

### Debug Mode
Enable WordPress debug mode to see detailed logs:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

## Security Considerations

### Self-Healing Risks
- **Automatic Updates** - May add untrusted domains
- **Policy Changes** - Could weaken security
- **Review Required** - Always review automatic changes

### Best Practices
- **Monitor Changes** - Review all policy updates
- **Test Thoroughly** - Test policy changes
- **Backup Policies** - Keep policy backups
- **Regular Review** - Review violations regularly

## Support

For support and documentation:
- **Website**: https://metricpoints.com
- **Documentation**: https://metricpoints.com/docs
- **Support Email**: hello@metricpoints.com
- **Developer**: Michael Loeffler (Main Street Web Developer)
- **Developer Website**: https://mainstreetwebdeveloper.com

## Credits

Developed by Michael Loeffler at Main Street Web Developer for MetricPoints.com

## Changelog

### Version 1.0.0
- Initial release
- CSP management
- Self-healing functionality
- Violation reporting
- Admin dashboard
